
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Port Scanner Tool</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        .loader {
            border: 4px solid rgba(0, 0, 0, 0.1);
            border-radius: 50%;
            border-top: 4px solid #3b82f6;
            width: 30px;
            height: 30px;
            animation: spin 1s linear infinite;
            margin: 20px auto;
            display: none;
        }

        @keyframes spin {
            0% {
                transform: rotate(0deg);
            }

            100% {
                transform: rotate(360deg);
            }
        }

        .port-status {
            transition: all 0.3s ease;
        }

        .port-open {
            background-color: #d1fae5;
            color: #065f46;
        }

        .port-closed {
            background-color: #fee2e2;
            color: #991b1b;
        }
    </style>
</head>

<body class="bg-gray-50 min-h-screen">
    <div class="container mx-auto px-4 py-12">
        <div class="max-w-2xl mx-auto bg-white rounded-lg shadow-md overflow-hidden">
            <div class="bg-blue-600 px-6 py-4">
                <div class="flex items-center">
                    <img src="https://placehold.co/40x40"
                        alt="Network security icon showing a shield protecting a server" class="mr-3" />
                    <h1 class="text-2xl font-bold text-white">Port Scanner Tool</h1>
                </div>
                <p class="text-blue-100 mt-1">Periksa port yang terbuka pada hostname atau alamat IP</p>
            </div>

            <div class="p-6">
                <div class="mb-6">
                    <label for="hostname" class="block text-sm font-medium text-gray-700 mb-1">Hostname/IP
                        Address</label>
                    <input type="text" id="hostname" placeholder="contoh: example.com atau 192.168.1.1"
                        class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-blue-500 focus:border-blue-500">
                </div>

                <div class="mb-6">
                    <label for="ports" class="block text-sm font-medium text-gray-700 mb-1">Ports (pisahkan dengan
                        koma)</label>
                    <input type="text" id="ports" placeholder="contoh: 80, 443, 8080, 3306"
                        class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-blue-500 focus:border-blue-500"
                        value="21, 22, 80, 443, 8080, 3306">
                </div>

                <div class="mb-4">
                    <label for="timeout" class="block text-sm font-medium text-gray-700 mb-1">Timeout (ms)</label>
                    <input type="number" id="timeout" placeholder="default: 2000"
                        class="w-32 px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-blue-500 focus:border-blue-500"
                        value="2000" min="500" max="10000">
                </div>

                <button id="scanBtn"
                    class="w-full bg-blue-600 hover:bg-blue-700 text-white font-bold py-3 px-4 rounded-md transition duration-150 ease-in-out focus:outline-none focus:ring-2 focus:ring-blue-500 focus:ring-offset-2">
                    Mulai Scan
                </button>

                <div id="loader" class="loader"></div>

                <div id="results" class="mt-6 hidden">